/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1999 Parametric Technology Corporation.
	All rights reserved.
*/

#include "stdafx.h"
#include "AdpClient.h"

#include "AdpClientDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "CProdUtils.h"
#include "AdpFuncs.h"
IApplication *pdApp = NULL;
IHelm *pHelm = NULL;
using namespace AdpExample;

/////////////////////////////////////////////////////////////////////////////
// CAdpClientDoc

IMPLEMENT_DYNCREATE(CAdpClientDoc, CDocument)

BEGIN_MESSAGE_MAP(CAdpClientDoc, CDocument)
	//{{AFX_MSG_MAP(CAdpClientDoc)
	ON_COMMAND(ID_SELECT, OnSelect)
	ON_COMMAND(ID_ALL_OBJECTS, OnShowAllObjects)
	ON_COMMAND(ID_SHOW_CHANGED_OBJECTS, OnShowChangedObjects)
	ON_COMMAND(ID_FIND_TOTAL_LENGTH, OnCalculateTotalLength)
	ON_COMMAND(ID_UPDATE_DISPNAMES, OnUpdateDisplayNames)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CAdpClientDoc, CDocument)
	//{{AFX_DISPATCH_MAP(CAdpClientDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//      DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IAdpClient to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {846A5FE9-1FE9-11D3-AB23-0008C711C359}
static const IID IID_IAdpClient =
{ 0x846a5fe9, 0x1fe9, 0x11d3, { 0xab, 0x23, 0x0, 0x8, 0xc7, 0x11, 0xc3, 0x59 } };

BEGIN_INTERFACE_MAP(CAdpClientDoc, CDocument)
	INTERFACE_PART(CAdpClientDoc, IID_IAdpClient, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAdpClientDoc construction/destruction

CAdpClientDoc::CAdpClientDoc()
{
	// TODO: add one-time construction code here

	EnableAutomation();

	AfxOleLockApp();
}

CAdpClientDoc::~CAdpClientDoc()
{
	AfxOleUnlockApp();
}

BOOL CAdpClientDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	HRESULT hr = RunProDESKTOP(&pdApp);
	if(FAILED(hr) || !pdApp)
		AfxMessageBox("Pro/DESKTOP could not be started");

	IPartDocument *pPartDoc = NULL;
	hr = pdApp->NewPart(&pPartDoc);
	if (hr || !pPartDoc) {
		AfxMessageBox("Could not create new part");
	}

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CAdpClientDoc serialization

void CAdpClientDoc::Serialize(CArchive& ar)
{
	HRESULT hr;
	if (ar.IsLoading()) {
		displayNameList.RemoveAll();
		displayNameList.Serialize(ar);
		return;
	}

	if (ar.IsStoring()) {
		hr = UpdateDisplayNameList(displayNameList);
		displayNameList.Serialize(ar);
		return;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CAdpClientDoc diagnostics

#ifdef _DEBUG
void CAdpClientDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CAdpClientDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAdpClientDoc commands

void CAdpClientDoc::OnSelect()
{
	displayNameList.RemoveAll();
	HRESULT hr = ConstructDisplayNameListForSelectedLines(displayNameList);
	return;	
}

void CAdpClientDoc::OnShowAllObjects()
{
	HRESULT hr;

	if (displayNameList.IsEmpty()) {
		AfxMessageBox("No DisplayName in Memory. Load display names.");
		return ;
	}

	hr = HighlightObjects(displayNameList);
	return ;
}

void CAdpClientDoc::OnShowChangedObjects()
{
	HRESULT hr;

	if (displayNameList.IsEmpty()) {
		AfxMessageBox("No DisplayName in Memory. Load display names.");
		return;
	}

	hr = HighlightChangedObjects(displayNameList);
}

void CAdpClientDoc::OnCalculateTotalLength()
{
	HRESULT hr;
	double lengthSum = 0.0;
	if (displayNameList.IsEmpty()) {
		AfxMessageBox("No DisplayName in Memory. Select lines or Load display names");
		return;
	}

	OnShowAllObjects(); // This will highlight the objects for whome length is being calculated.

	hr = CalculateTotalCurveLength(displayNameList, lengthSum);

	CString message;
	message.Format("Total length of curves(m) = %f",lengthSum);
	AfxMessageBox(message);
	return;
}

void CAdpClientDoc::OnUpdateDisplayNames()
{
	HRESULT hr = UpdateDisplayNameList(displayNameList);
	if (FAILED(hr))
		AfxMessageBox("Could not update");
}

void CAdpClientDoc::OnCloseDocument()
{
	HRESULT hr = CloseProDESKTOP();
	CDocument::OnCloseDocument();
}

BOOL CAdpClientDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	OnShowAllObjects();

	return TRUE;
}
